
/** I N C L U D E S **********************************************************/
#include <p18cxxx.h>
#include "typedefs.h"                   
#include "usb.h"                         
#include "io_cfg.h"                     
#include "BootPIC18NonJ.h"

/** Configuration bits for PIC18F2550 ****************************************/
//#pragma config PLLDIV = 12		//48 MHz Clock Input
#pragma config PLLDIV = 5			//20 MHz Clock Input
#pragma config CPUDIV = OSC1_PLL2
#pragma config USBDIV = 2 			//USB clock source comes from the 96 MHz PLL divided by 2
#pragma config FOSC =  ECIO_EC		//External Clock Source, I/O Pin Enabled
#pragma config FCMEN = OFF 			//Fail-Safe Clock Monitor disabled
#pragma config IESO = OFF 			//Oscillator Switchover mode disabled
#pragma config PWRT = OFF 			//PWRT disabled
#pragma config BOR = OFF 			//Brown-out Reset disabled in hardware and software
#pragma config BORV = 0 			//Maximum setting
#pragma config VREGEN = ON 			//USB voltage regulator enabled 
#pragma config WDT = OFF 			//HW Disabled - SW Controlled
#pragma config WDTPS = 1 			//1:1
#pragma config MCLRE = ON 			//MCLR pin enabled; RE3 input pin disabled
#pragma config LPT1OSC = OFF 		//Timer1 configured for higher power operation
#pragma config PBADEN = OFF 		//PORTB<4:0> pins are configured as digital I/O on Reset
#pragma config CCP2MX = OFF 		//CCP2 input/output is multiplexed with RB3 
#pragma config STVREN = OFF 		//Stack full/underflow will not cause Reset
#pragma config LVP = OFF 			//Single-Supply ICSP disabled 
#pragma config XINST = OFF 			//Instruction set extension and Indexed Addressing mode disabled (Legacy mode)
#pragma config DEBUG = OFF 			//Background debugger enabled, RB6 and RB7 are dedicated to In-Circuit Debug
#pragma config CP0 = OFF 			//Block 0 (000800-001FFFh) not code-protected
#pragma config CP1 = OFF 			//Block 1 (002000-003FFFh) not code-protected
#pragma config CP2 = OFF 			//Block 2 (004000-005FFFh) not code-protected
#pragma config CP3 = OFF 			//Block 3 (006000-007FFFh) not code-protected
#pragma config CPB = OFF 			//Boot block (000000-0007FFh) not code-protected
#pragma config CPD = OFF 			//Data EEPROM not code-protected
#pragma config WRT0 = OFF 			//Block 0 (000800-001FFFh) not write-protected
#pragma config WRT1 = OFF 			//Block 1 (002000-003FFFh) not write-protected
#pragma config WRT2 = OFF 			//Block 2 (004000-005FFFh) not write-protected
#pragma config WRT3 = OFF 			//Block 3 (006000-007FFFh) not write-protected
#pragma config WRTB = OFF 			//Boot block (000000-0007FFh) not write-protected
#pragma config WRTC = OFF 			//Configuration registers (300000-3000FFh) not write-protected
#pragma config WRTD = OFF 			//Data EEPROM not write-protected
#pragma config EBTR0 = OFF 			//Block 0 (000800-001FFFh) not protected from table reads executed in other blocks
#pragma config EBTR1 = OFF 			//Block 1 (002000-003FFFh) not protected from table reads executed in other blocks
#pragma config EBTR2 = OFF 			//Block 2 (004000-005FFFh) not protected from table reads executed in other blocks
#pragma config EBTR3 = OFF 			//Block 3 (006000-007FFFh) not protected from table reads executed in other blocks
#pragma config EBTRB = OFF 			//Boot block (000000-0007FFh) not protected from table reads executed in other blocks

/** V A R I A B L E S ********************************************************/
#pragma udata

/** P R I V A T E  P R O T O T Y P E S ***************************************/
static void InitializeSystem(void);
void USBTasks(void);
void BlinkUSBStatus(void);

/** V E C T O R  R E M A P P I N G *******************************************/
#pragma code high_vector=0x08
void interrupt_at_high_vector(void)
{
    _asm goto 0x1108 _endasm
}
#pragma code low_vector=0x18
void interrupt_at_low_vector(void)
{
    _asm goto 0x1118 _endasm
}
#pragma code


/** D E C L A R A T I O N S **************************************************/
#pragma code


void main(void)
{   
    //Check Bootload Mode Entry Condition using POR
	if(RCONbits.POR == 1)
	{
		RCONbits.POR = 0;
	}
	else
	{
		RCONbits.POR = 1;
		_asm
		goto 0x1100
		_endasm
	}

    InitializeSystem();
    while(1)
    {
		ClrWdt();	
	    USBTasks();

		BlinkUSBStatus();
		
	    if((usb_device_state == CONFIGURED_STATE) && (UCONbits.SUSPND != 1))
	    {
 	       ProcessIO();
 	    }				  
    }
}


static void InitializeSystem(void)
{
    mInitializeUSBDriver();
    UserInit();
}


void USBTasks(void)
{
    USBCheckBusStatus();
    USBDriverService();
}


void BlinkUSBStatus(void)
{
    static word led_count=0;

    if(led_count == 0)led_count = 10000U;
    led_count--;

	 if(usb_device_state < CONFIGURED_STATE)
	 {
		 mLED_1_On();
	 } 
	 else
     {
         if(led_count==0)
         {
             mLED_1_Toggle();
         }
     }
}
